local scrollTextBg={}
local image
local x1,x2
local speed=412.5
local y=1081
local originalY=1081
local targetY=877
local moveTimer=0
local moveDuration=3
local state="idle"
local visible=false
function scrollTextBg.load()
image=love.graphics.newImage("scrolltext-bg.png")
if not image then error("scrolltext-bg.png could not be loaded!") end
x1=0
x2=image:getWidth()
end
function scrollTextBg.update(dt)
x1=x1-speed*dt
x2=x2-speed*dt
if x1<=-image:getWidth() then x1=x2+image:getWidth() end
if x2<=-image:getWidth() then x2=x1+image:getWidth() end
if state=="movingUp" then
moveTimer=moveTimer+dt
local t=moveTimer/moveDuration
if t>1 then t=1 end
y=originalY-(originalY-targetY)*t
if t>=1 then state="idle" end
elseif state=="movingDown" then
moveTimer=moveTimer+dt
local t=moveTimer/moveDuration
if t>1 then t=1 end
y=targetY+(originalY-targetY)*t
if t>=1 then state="idle";visible=false end
end end
function scrollTextBg.draw()
if visible then
love.graphics.setColor(1,1,1,1)
love.graphics.draw(image,x1,y)
love.graphics.draw(image,x2,y)
end end
function scrollTextBg.setVisible(stateValue)
visible=stateValue
end
function scrollTextBg.startMovingUp()
if state=="idle" then state="movingUp";moveTimer=0 end
end
function scrollTextBg.startMovingDown()
if state=="idle" then state="movingDown";moveTimer=0 end
end
return scrollTextBg
